/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crusher;

import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class CrushingWheelControllerBlockEntity
extends SmartBlockEntity {
    public Entity processingEntity;
    private UUID entityUUID;
    protected boolean searchForEntity;
    public ProcessingInventory inventory;
    protected LazyOptional<IItemHandlerModifiable> handler = LazyOptional.of(() -> this.inventory);
    private RecipeWrapper wrapper;
    public float crushingspeed;

    public CrushingWheelControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inventory = new ProcessingInventory(this::itemInserted){

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return super.isItemValid(slot, stack) && CrushingWheelControllerBlockEntity.this.processingEntity == null;
            }
        };
        this.wrapper = new RecipeWrapper((IItemHandlerModifiable)this.inventory);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        behaviours.add(new DirectBeltInputBehaviour(this).onlyInsertWhen(this::supportsDirectBeltInput));
    }

    private boolean supportsDirectBeltInput(Direction side) {
        BlockState blockState = this.m_58900_();
        if (blockState == null) {
            return false;
        }
        Direction direction = (Direction)blockState.m_61143_((Property)CrushingWheelControllerBlock.f_52588_);
        return direction == Direction.DOWN || direction == side;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.searchForEntity) {
            this.searchForEntity = false;
            List search = this.f_58857_.m_6249_((Entity)null, new AABB(this.m_58899_()), e -> this.entityUUID.equals(e.m_20148_()));
            if (search.isEmpty()) {
                this.clear();
            } else {
                this.processingEntity = (Entity)search.get(0);
            }
        }
        if (!this.isOccupied()) {
            return;
        }
        if (this.crushingspeed == 0.0f) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.tickAudio());
        }
        float speed = this.crushingspeed * 4.0f;
        Vec3 centerPos = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)CrushingWheelControllerBlock.f_52588_);
        int offset = facing.m_122421_().m_122540_();
        Vec3 outSpeed = new Vec3((facing.m_122434_() == Direction.Axis.X ? 0.25 : 0.0) * (double)offset, offset == 1 ? (facing.m_122434_() == Direction.Axis.Y ? 0.5 : 0.0) : 0.0, (facing.m_122434_() == Direction.Axis.Z ? 0.25 : 0.0) * (double)offset);
        Vec3 outPos = centerPos.m_82520_((double)(facing.m_122434_() == Direction.Axis.X ? 0.55f * (float)offset : 0.0f), (double)(facing.m_122434_() == Direction.Axis.Y ? 0.55f * (float)offset : 0.0f), (double)(facing.m_122434_() == Direction.Axis.Z ? 0.55f * (float)offset : 0.0f));
        if (!this.hasEntity()) {
            BlockPos nextPos;
            DirectBeltInputBehaviour behaviour;
            float processingSpeed = Mth.m_14036_((float)(speed / (float)(!this.inventory.appliedRecipe ? Mth.m_14173_((int)this.inventory.getStackInSlot(0).m_41613_()) : 1)), (float)0.25f, (float)20.0f);
            this.inventory.remainingTime -= processingSpeed;
            this.spawnParticles(this.inventory.getStackInSlot(0));
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (this.inventory.remainingTime < 20.0f && !this.inventory.appliedRecipe) {
                this.applyRecipe();
                this.inventory.appliedRecipe = true;
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
                return;
            }
            if (this.inventory.remainingTime > 0.0f) {
                return;
            }
            this.inventory.remainingTime = 0.0f;
            if (facing != Direction.UP && (behaviour = BlockEntityBehaviour.get((BlockGetter)this.f_58857_, nextPos = this.f_58858_.m_7918_(facing.m_122434_() == Direction.Axis.X ? 1 * offset : 0, -1, facing.m_122434_() == Direction.Axis.Z ? 1 * offset : 0), DirectBeltInputBehaviour.TYPE)) != null) {
                boolean changed = false;
                if (!behaviour.canInsertFromSide(facing)) {
                    return;
                }
                for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                    ItemStack remainder;
                    ItemStack stack = this.inventory.getStackInSlot(slot);
                    if (stack.m_41619_() || (remainder = behaviour.handleInsertion(stack, facing, false)).equals(stack, false)) continue;
                    this.inventory.setStackInSlot(slot, remainder);
                    changed = true;
                }
                if (changed) {
                    this.m_6596_();
                    this.sendData();
                }
                return;
            }
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (stack.m_41619_()) continue;
                ItemEntity entityIn = new ItemEntity(this.f_58857_, outPos.f_82479_, outPos.f_82480_, outPos.f_82481_, stack);
                entityIn.m_20256_(outSpeed);
                entityIn.getPersistentData().m_128365_("BypassCrushingWheel", (Tag)NbtUtils.m_129224_((BlockPos)this.f_58858_));
                this.f_58857_.m_7967_((Entity)entityIn);
            }
            this.inventory.clear();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
            return;
        }
        if (!this.processingEntity.m_6084_() || !this.processingEntity.m_20191_().m_82381_(new AABB(this.f_58858_).m_82400_(0.5))) {
            this.clear();
            return;
        }
        double xMotion = ((double)((float)this.f_58858_.m_123341_() + 0.5f) - this.processingEntity.m_20185_()) / 2.0;
        double zMotion = ((double)((float)this.f_58858_.m_123343_() + 0.5f) - this.processingEntity.m_20189_()) / 2.0;
        if (this.processingEntity.m_6144_()) {
            zMotion = 0.0;
            xMotion = 0.0;
        }
        double movement = Math.max(-speed / 4.0f, -0.5f) * (float)(-offset);
        this.processingEntity.m_20256_(new Vec3(facing.m_122434_() == Direction.Axis.X ? movement : xMotion, facing.m_122434_() == Direction.Axis.Y ? movement : 0.0, facing.m_122434_() == Direction.Axis.Z ? movement : zMotion));
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!(this.processingEntity instanceof ItemEntity)) {
            Vec3 entityOutPos = outPos.m_82520_(facing.m_122434_() == Direction.Axis.X ? (double)(0.5f * (float)offset) : 0.0, facing.m_122434_() == Direction.Axis.Y ? (double)(0.5f * (float)offset) : 0.0, facing.m_122434_() == Direction.Axis.Z ? (double)(0.5f * (float)offset) : 0.0);
            int crusherDamage = (Integer)AllConfigs.server().kinetics.crushingDamage.get();
            if (this.processingEntity instanceof LivingEntity && ((LivingEntity)this.processingEntity).m_21223_() - (float)crusherDamage <= 0.0f && ((LivingEntity)this.processingEntity).f_20916_ <= 0) {
                this.processingEntity.m_6034_(entityOutPos.f_82479_, entityOutPos.f_82480_, entityOutPos.f_82481_);
            }
            this.processingEntity.m_6469_(CreateDamageSources.crush(this.f_58857_), (float)crusherDamage);
            if (!this.processingEntity.m_6084_()) {
                this.processingEntity.m_6034_(entityOutPos.f_82479_, entityOutPos.f_82480_, entityOutPos.f_82481_);
            }
            return;
        }
        ItemEntity itemEntity = (ItemEntity)this.processingEntity;
        itemEntity.m_32010_(20);
        if (facing.m_122434_() == Direction.Axis.Y) {
            if (this.processingEntity.m_20186_() * (double)(-offset) < (centerPos.f_82480_ - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (facing.m_122434_() == Direction.Axis.Z) {
            if (this.processingEntity.m_20189_() * (double)(-offset) < (centerPos.f_82481_ - 0.25) * (double)(-offset)) {
                this.intakeItem(itemEntity);
            }
        } else if (this.processingEntity.m_20185_() * (double)(-offset) < (centerPos.f_82479_ - 0.25) * (double)(-offset)) {
            this.intakeItem(itemEntity);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        float pitch = Mth.m_14036_((float)(this.crushingspeed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (this.entityUUID == null && this.inventory.getStackInSlot(0).m_41619_()) {
            return;
        }
        SoundScapes.play(SoundScapes.AmbienceGroup.CRUSHING, this.f_58858_, pitch);
    }

    private void intakeItem(ItemEntity itemEntity) {
        this.inventory.clear();
        this.inventory.setStackInSlot(0, itemEntity.m_32055_().m_41777_());
        this.itemInserted(this.inventory.getStackInSlot(0));
        itemEntity.m_146870_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 18);
    }

    protected void spawnParticles(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        Object particleData = null;
        particleData = stack.m_41720_() instanceof BlockItem ? new BlockParticleOption(ParticleTypes.f_123794_, ((BlockItem)stack.m_41720_()).m_40614_().m_49966_()) : new ItemParticleOption(ParticleTypes.f_123752_, stack);
        RandomSource r = this.f_58857_.f_46441_;
        for (int i = 0; i < 4; ++i) {
            this.f_58857_.m_7106_((ParticleOptions)particleData, (double)((float)this.f_58858_.m_123341_() + r.m_188501_()), (double)((float)this.f_58858_.m_123342_() + r.m_188501_()), (double)((float)this.f_58858_.m_123343_() + r.m_188501_()), 0.0, 0.0, 0.0);
        }
    }

    private void applyRecipe() {
        Optional<ProcessingRecipe<RecipeWrapper>> recipe = this.findRecipe();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (recipe.isPresent()) {
            int rolls = this.inventory.getStackInSlot(0).m_41613_();
            this.inventory.clear();
            for (int roll = 0; roll < rolls; ++roll) {
                List<ItemStack> rolledResults = recipe.get().rollResults();
                for (int i = 0; i < rolledResults.size(); ++i) {
                    ItemStack stack = rolledResults.get(i);
                    ItemHelper.addToList(stack, list);
                }
            }
            for (int slot = 0; slot < list.size() && slot + 1 < this.inventory.getSlots(); ++slot) {
                this.inventory.setStackInSlot(slot + 1, (ItemStack)list.get(slot));
            }
        } else {
            this.inventory.clear();
        }
    }

    public Optional<ProcessingRecipe<RecipeWrapper>> findRecipe() {
        Optional<ProcessingRecipe<Object>> crushingRecipe = AllRecipeTypes.CRUSHING.find(this.wrapper, this.f_58857_);
        if (!crushingRecipe.isPresent()) {
            crushingRecipe = AllRecipeTypes.MILLING.find(this.wrapper, this.f_58857_);
        }
        return crushingRecipe;
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.hasEntity()) {
            compound.m_128365_("Entity", (Tag)NbtUtils.m_129226_((UUID)this.entityUUID));
        }
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128350_("Speed", this.crushingspeed);
        super.write(compound, clientPacket);
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (compound.m_128441_("Entity") && !this.isOccupied()) {
            this.entityUUID = NbtUtils.m_129233_((Tag)NBTHelper.getINBT(compound, "Entity"));
            this.searchForEntity = true;
        }
        this.crushingspeed = compound.m_128457_("Speed");
        this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
    }

    public void startCrushing(Entity entity) {
        this.processingEntity = entity;
        this.entityUUID = entity.m_20148_();
    }

    private void itemInserted(ItemStack stack) {
        Optional<ProcessingRecipe<RecipeWrapper>> recipe = this.findRecipe();
        this.inventory.remainingTime = recipe.isPresent() ? (float)recipe.get().getProcessingDuration() : 100.0f;
        this.inventory.appliedRecipe = false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void clear() {
        this.processingEntity = null;
        this.entityUUID = null;
    }

    public boolean isOccupied() {
        return this.hasEntity() || !this.inventory.isEmpty();
    }

    public boolean hasEntity() {
        return this.processingEntity != null;
    }
}

